/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.BuildPathElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.BuildPathNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildPathsNode
extends BaseNode<Property> {
    private static final Image BUILD_PATHS_ICON = ScriptingUIPlugin.getImage("icons/folder.png");
    private BuildPathNode[] buildPaths;

    BuildPathsNode(BundleElement bundle) {
        this(bundle.getBuildPaths());
    }

    BuildPathsNode(List<BuildPathElement> elements) {
        ArrayList<BuildPathNode> paths = new ArrayList<BuildPathNode>();
        if (elements != null) {
            for (BuildPathElement buildPath : elements) {
                paths.add(new BuildPathNode(buildPath));
            }
        }
        this.buildPaths = paths.toArray(new BuildPathNode[paths.size()]);
    }

    @Override
    public Object[] getChildren() {
        return this.buildPaths;
    }

    @Override
    public Image getImage() {
        return BUILD_PATHS_ICON;
    }

    @Override
    public String getLabel() {
        return Messages.BuildPathsNode_Build_Paths;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public boolean hasChildren() {
        return this.buildPaths.length > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Property implements IPropertyInformation<BuildPathsNode>
    {
        COUNT(Messages.BuildPathsNode_Build_Paths_Count){

            public Object getPropertyValue(BuildPathsNode node) {
                return node.buildPaths.length;
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }

        @Override
        public Object getPropertyValue(BuildPathsNode node) {
            return null;
        }
    }
}

